<?php
// The source code packaged with this file is Free Software, Copyright (C) 2005 by
// Ricardo Galli <gallir at uib dot es>.
// It's licensed under the AFFERO GENERAL PUBLIC LICENSE unless stated otherwise.
// You can get copies of the licenses here:
// 		http://www.affero.org/oagpl.html
// AFFERO GENERAL PUBLIC LICENSE is also included in the file called "COPYING".

include_once('Smarty.class.php');
$main_smarty = new Smarty;

include('config.php');
include(mnminclude.'html1.php');
include(mnminclude.'ts.php');
include(mnminclude.'link.php');
include(mnminclude.'tags.php');
include(mnminclude.'smartyvariables.php');

// html tags allowed during submit
$main_smarty->assign('Story_Content_Tags_To_Allow', htmlspecialchars(Story_Content_Tags_To_Allow));

// breadcrumbs and page titles
$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_Submit');
$navwhere['link1'] = getmyurl('submit', '');
$main_smarty->assign('navbar_where', $navwhere);
$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_Submit'));
$main_smarty = do_sidebar($main_smarty);

// make sure user is logged in
force_authentication();

// module system hook
$vars = '';
check_actions('submit_post_authentication', $vars);

// this is for direct links from weblogs
if(empty($_POST['phase']) && !empty($_GET['url'])) {
	$_POST['phase'] = 1;
	$_POST['url'] = $_GET['url'];
	$_POST['randkey'] = rand(10000,10000000);
	if(!empty($_GET['trackback'])) 
	$_POST['trackback'] = $_GET['trackback'];
}

// determine which step of the submit process we are on
if(isset($_POST["phase"])) {
	$phase = $_POST["phase"]; 
} 
else {
	$phase = 0;
}

// If show URL input box is disabled, go straight to step 2
if($phase == 0 && Submit_Show_URL_Input == false) {
	$phase = 1;
}
switch ($phase) {
	case 0:
		do_submit0();
		break;
	case 1:
		do_submit1();
		break;
	case 2:
		do_submit2();
		break;
	case 3:
		do_submit3();
		break;
}

exit;

// enter URL before submit process
function do_submit0() {
	global $main_smarty, $the_template;
	$main_smarty->assign('submit_rand', rand(10000,10000000));
	$main_smarty->assign('Submit_Show_URL_Input', Submit_Show_URL_Input);
	$main_smarty->assign('Submit_Require_A_URL', Submit_Require_A_URL);
	
	define('pagename', 'submit'); 
	$main_smarty->assign('pagename', pagename);
	
	$main_smarty->assign('tpl_center', $the_template . '/submit_step_1');
	$vars = '';
	check_actions('do_submit0', $vars);
	$main_smarty->display($the_template . '/pligg.tpl');
}

// submit step 1
function do_submit1() {
	global $main_smarty, $db, $dblang, $current_user, $the_template;

	$url = htmlspecialchars(strip_tags(trim($_POST['url'])));
	$url = str_replace('&amp;', '&', $url);  
	$url = html_entity_decode($url);
	
	$linkres=new Link;
	$linkres->randkey = strip_tags($_POST['randkey']);

	if(Submit_Show_URL_Input == false) {
		$url = "http://";	
		$linkres->randkey = rand(10000,10000000);
	}
	$Submit_Show_URL_Input = Submit_Show_URL_Input;
	if($url == "http://" || $url == ""){
		$Submit_Show_URL_Input = false;
	}
	
	$main_smarty->assign('randkey', $linkres->randkey);	
	$main_smarty->assign('submit_url', $url);
	$main_smarty->assign('Submit_Show_URL_Input', $Submit_Show_URL_Input);
	$main_smarty->assign('Submit_Require_A_URL', Submit_Require_A_URL);

	$edit = false;
	$linkres->get($url);
	
	$trackback=$linkres->trackback;

	if($url == "http://" || $url == ""){
		if(Submit_Require_A_URL == false){
			$linkres->valid = true;}
		else{
			$linkres->valid = false;
		}
		$linkres->url_title = "";
	}
	
	$vars = array("url" => $url,'linkres'=>$linkres);
	check_actions('submit_validating_url', $vars);
	$linkres = $vars['linkres'];
	
	if(!$linkres->valid) {
		$main_smarty->assign('submit_error', 'invalidurl');
		$main_smarty->assign('tpl_center', $the_template . '/submit_errors');
		
		$main_smarty->display($the_template . '/pligg.tpl');
		return;
	}
	
	if(Submit_Require_A_URL == true || ($url != "http://" && $url != "")){
		if($linkres->duplicates($url) > 0) {
			$main_smarty->assign('submit_search', getmyurl("search_url", htmlentities($url)));
			$main_smarty->assign('submit_error', 'dupeurl');
			$main_smarty->assign('tpl_center', $the_template . '/submit_errors');
			
			define('pagename', 'submit'); 
     	$main_smarty->assign('pagename', pagename);
			
			$main_smarty->display($the_template . '/pligg.tpl');
			return;
		}
	}

	$vars = array("url" => $url);
	check_actions('submit_validating_url', $vars);
	
	totals_adjust_count('discard', 1);

	$linkres->status='discard';
	$linkres->author=$current_user->user_id;
	$linkres->store();

	$main_smarty->assign('StorySummary_ContentTruncate', StorySummary_ContentTruncate);
	$main_smarty->assign('SubmitSummary_Allow_Edit', SubmitSummary_Allow_Edit);
	$main_smarty->assign('enable_tags', Enable_Tags);
	$main_smarty->assign('submit_url_title', $linkres->url_title);
	$main_smarty->assign('submit_id', $linkres->id);
	$main_smarty->assign('submit_type', $linkres->type());
	if(isset($link_title)){$main_smarty->assign('submit_title', $link_title);}
	if(isset($link_content)){$main_smarty->assign('submit_content', $link_content);}
	$main_smarty->assign('submit_trackback', $trackback);
	$main_smarty->assign('submit_link_field1', $linkres->link_field1);
	$main_smarty->assign('submit_link_field2', $linkres->link_field2);
	$main_smarty->assign('submit_link_field3', $linkres->link_field3);
	$main_smarty->assign('submit_link_field4', $linkres->link_field4);
	$main_smarty->assign('submit_link_field5', $linkres->link_field5);
	$main_smarty->assign('submit_link_field6', $linkres->link_field6);
	$main_smarty->assign('submit_link_field7', $linkres->link_field7);
	$main_smarty->assign('submit_link_field8', $linkres->link_field8);
	$main_smarty->assign('submit_link_field9', $linkres->link_field9);
	$main_smarty->assign('submit_link_field10', $linkres->link_field10);
	$main_smarty->assign('submit_link_field11', $linkres->link_field11);
	$main_smarty->assign('submit_link_field12', $linkres->link_field12);
	$main_smarty->assign('submit_link_field13', $linkres->link_field13);
	$main_smarty->assign('submit_link_field14', $linkres->link_field14);
	$main_smarty->assign('submit_link_field15', $linkres->link_field15);

	include_once(mnminclude.'dbtree.php');
	$array = tree_to_array(0, table_categories, FALSE);
	$main_smarty->assign('submit_lastspacer', 0);
	$main_smarty->assign('submit_cat_array', $array);


	$main_smarty->assign('Spell_Checker', Spell_Checker);

	$main_smarty->assign('tpl_extra_fields', $the_template . '/submit_extra_fields');
	$main_smarty->assign('tpl_center', $the_template . '/submit_step_2');
	
	define('pagename', 'submit'); 
	$main_smarty->assign('pagename', pagename);
	
	$vars = '';
	check_actions('do_submit1', $vars);
	$main_smarty->display($the_template . '/pligg.tpl');
}

// submit step 2
function do_submit2() {
	global $db, $main_smarty, $dblang, $the_template, $linkres, $current_user;

	$main_smarty->assign('auto_vote', auto_vote);
	$main_smarty->assign('Submit_Show_URL_Input', Submit_Show_URL_Input);
	$main_smarty->assign('Submit_Require_A_URL', Submit_Require_A_URL);

	$linkres=new Link;

	$linkres->id=$link_id = $_POST['id'];
	
	if(!$linkres->verify_ownership($current_user->user_id)){
		die($main_smarty->get_config_vars('PLIGG_Visual_Submit2Errors_NoAccess'));
	}
	
	$linkres->read(FALSE);

	if($linkres->votes($current_user->user_id) == 0 && auto_vote == true) {
		$linkres->insert_vote($current_user->user_id, '10');
		$linkres->store_basic();
		$linkres->read(FALSE); 
	}
	
	$linkres->category=$_POST['category'];
	$linkres->title = strip_tags(trim($_POST['title']));
	$linkres->title_url = makeUrlFriendly($linkres->title);
	$linkres->tags = tags_normalize_string(strip_tags(trim($_POST['tags'])));
	$linkres->content = strip_tags(trim($_POST['bodytext']), Story_Content_Tags_To_Allow);
	$linkres->content = str_replace("\n", "<br />", $linkres->content);
	// Steef 2k7-07 security fix start ----------------------------------------------------------
		if(isset($_POST['link_field1'])){$linkres->link_field1 = strip_tags(trim($_POST['link_field1']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field2'])){$linkres->link_field2 = strip_tags(trim($_POST['link_field2']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field3'])){$linkres->link_field3 = strip_tags(trim($_POST['link_field3']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field4'])){$linkres->link_field4 = strip_tags(trim($_POST['link_field4']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field5'])){$linkres->link_field5 = strip_tags(trim($_POST['link_field5']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field6'])){$linkres->link_field6 = strip_tags(trim($_POST['link_field6']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field7'])){$linkres->link_field7 = strip_tags(trim($_POST['link_field7']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field8'])){$linkres->link_field8 = strip_tags(trim($_POST['link_field8']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field9'])){$linkres->link_field9 = strip_tags(trim($_POST['link_field9']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field10'])){$linkres->link_field10 = strip_tags(trim($_POST['link_field10']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field11'])){$linkres->link_field11 = strip_tags(trim($_POST['link_field11']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field12'])){$linkres->link_field12 = strip_tags(trim($_POST['link_field12']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field13'])){$linkres->link_field13 = strip_tags(trim($_POST['link_field13']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field14'])){$linkres->link_field14 = strip_tags(trim($_POST['link_field14']), Story_Content_Tags_To_Allow);}
		if(isset($_POST['link_field15'])){$linkres->link_field15 = strip_tags(trim($_POST['link_field15']), Story_Content_Tags_To_Allow);}
	// Steef 2k7-07 security fix end --------------------------------------------------------------

	if(!isset($_POST['summarytext'])){
		$linkres->link_summary = utf8_substr(strip_tags(trim($_POST['bodytext']), Story_Content_Tags_To_Allow), 0, StorySummary_ContentTruncate - 1);
		$linkres->link_summary = str_replace("\n", "<br />", $linkres->link_summary);		
	} else {
		$linkres->link_summary = strip_tags(trim($_POST['summarytext']), Story_Content_Tags_To_Allow);
		$linkres->link_summary = str_replace("\n", "<br />", $linkres->link_summary);
		if(strlen($linkres->link_summary) > StorySummary_ContentTruncate){
			loghack('SubmitAStory-SummaryGreaterThanLimit', 'username: ' . $_POST["username"].'|email: '.$_POST["email"], true);
			$linkres->link_summary = utf8_substr($linkres->link_summary, 0, StorySummary_ContentTruncate - 1);
			$linkres->link_summary = str_replace("\n", "<br />", $linkres->link_summary);
		}
	}
	
	if (link_errors($linkres)) {
		return;
	}

	$linkres->store();
	tags_insert_string($linkres->id, $dblang, $linkres->tags);
	$vars = '';
	check_actions('submit_step_3_after_first_store', $vars);
	$linkres->read(FALSE);
	$edit = true;
	$link_title = $linkres->title;
	$link_content = $linkres->content;
	$link_title = stripslashes(strip_tags(trim($_POST['title'])));
	$main_smarty->assign('the_story', $linkres->print_summary('full', true));
	
	$main_smarty->assign('tags', $linkres->tags);
	if (!empty($linkres->tags)) {
		$tags_words = str_replace(",", ", ", $linkres->tags);
		$tags_url = urlencode($linkres->tags);
		$main_smarty->assign('tags_words', $tags_words);
		$main_smarty->assign('tags_url', $tags_url);
	}

	if(isset($url)){
		$main_smarty->assign('submit_url', $url);
	} else {
		$main_smarty->assign('submit_url', '');
	}
	$main_smarty->assign('submit_url_title', $linkres->url_title);
	$main_smarty->assign('submit_id', $linkres->id);
	$main_smarty->assign('submit_type', $linkres->type());
	$main_smarty->assign('submit_title', $link_title);
	$main_smarty->assign('submit_content', $link_content);
	if(isset($trackback)){
		$main_smarty->assign('submit_trackback', $trackback);
	} else {
		$main_smarty->assign('submit_trackback', '');
	}
			
	$main_smarty->assign('tpl_extra_fields', $the_template . '/submit_extra_fields');
	$main_smarty->assign('tpl_center', $the_template . '/submit_step_3');
	
	define('pagename', 'submit'); 
	$main_smarty->assign('pagename', pagename);

	$vars = '';	
	check_actions('do_submit2', $vars);
	$main_smarty->display($the_template . '/pligg.tpl');
	
}

// submit step 3
function do_submit3() {
	global $db;

	$linkres=new Link;

	$linkres->id=$link_id = strip_tags($_POST['id']);
	if(!is_numeric($linkres->id))die();
	$linkres->read();

	totals_adjust_count($linkres->status, -1);
	totals_adjust_count('queued', 1);

	$linkres->status='queued';

	$vars = array('linkres'=>$linkres);
	check_actions('do_submit3', $vars);

	$linkres->store_basic();
	$linkres->check_should_publish();
	
	if(!empty($_POST['trackback'])) {
		require_once(mnminclude.'trackback.php');
		$trackres = new Trackback;
		$trackres->url=trim($_POST['trackback']);
		$trackres->link=$linkres->id;
		$trackres->title=$linkres->title;
		$trackres->author=$linkres->author;
		$trackres->content=$linkres->content;
		$res = $trackres->send();
	}

	header("Location: " . getmyurl('upcoming'));
	die;

}

// assign any errors found during submit
function link_errors($linkres)
{
	global $main_smarty, $the_template;
	$error = false;

	if($_POST['randkey'] !== $linkres->randkey) { // random key error
		$main_smarty->assign('submit_error', 'badkey');
		$main_smarty->display($the_template . '/submit_errors.tpl');
		$error = true;
	}
	if($linkres->status != 'discard') { // if link has already been submitted
		$main_smarty->assign('submit_error', 'hashistory');
		$main_smarty->assign('submit_error_history', $linkres->status);
		$main_smarty->display($the_template . '/submit_errors.tpl');
		$error = true;
	}
	if(strlen($linkres->title) < minTitleLength  || strlen($linkres->content) < minStoryLength ) { // if link title or descrition is too short
		$main_smarty->assign('submit_error', 'incomplete');
		$main_smarty->display($the_template . '/submit_errors.tpl');
		$error = true;
	}
	if(preg_match('/.*http:\//', $linkres->title)) { // if URL is found in link title
		$main_smarty->assign('submit_error', 'urlintitle');
		$main_smarty->display($the_template . '/submit_errors.tpl');
		$error = true;
	}
	if(!$linkres->category > 0) { // if no category is selected
		$main_smarty->assign('submit_error', 'nocategory');
		$main_smarty->display($the_template . '/submit_errors.tpl');
		$error = true;
	}
	return $error;
}
?>
